/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.factory.PowerFactory;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class PowerTypeReference<T extends Power>
extends PowerType<T> {
    private PowerType<T> referencedPowerType;
    private int cooldown = 0;

    public PowerTypeReference(ResourceLocation id) {
        super(id, null);
    }

    @Override
    public PowerFactory.Instance getFactory() {
        this.getReferencedPowerType();
        if (this.referencedPowerType == null) {
            return null;
        }
        return this.referencedPowerType.getFactory();
    }

    @Override
    public boolean isActive(Entity entity) {
        this.getReferencedPowerType();
        if (this.referencedPowerType == null) {
            return false;
        }
        return this.referencedPowerType.isActive(entity);
    }

    @Override
    public T get(Entity entity) {
        this.getReferencedPowerType();
        if (this.referencedPowerType == null) {
            return null;
        }
        return this.referencedPowerType.get(entity);
    }

    public PowerType<T> getReferencedPowerType() {
        if (this.isReferenceInvalid()) {
            if (this.cooldown > 0) {
                --this.cooldown;
                return null;
            }
            try {
                this.referencedPowerType = null;
                this.referencedPowerType = PowerTypeRegistry.get(this.getIdentifier());
            }
            catch (IllegalArgumentException e) {
                this.cooldown = 600;
            }
        }
        return this.referencedPowerType;
    }

    private boolean isReferenceInvalid() {
        if (this.referencedPowerType != null && PowerTypeRegistry.contains(this.referencedPowerType.getIdentifier())) {
            PowerType type = PowerTypeRegistry.get(this.referencedPowerType.getIdentifier());
            return type != this.referencedPowerType;
        }
        return true;
    }
}

